/**  @file bta_focus_preproc.h
*
*    @brief This filter applies a laplace operator
*
*    BLT_DISCLAIMER
*
*    @author Alex Falkensteiner
*
*    @cond svn
*
*    Information of last commit
*    $Rev::               $:  Revision of last commit
*    $Author::            $:  Author of last commit
*    $Date::              $:  Date of last commit
*
*    @endcond
*/

#include <bta.h>
#include <bta_helper.h>
#include <bta_filters.h>

#ifndef BTA_EXCLUDE_FILTERS

#ifndef BTA_FOCUS_PREPROC_H_INCLUDED
#define BTA_FOCUS_PREPROC_H_INCLUDED


typedef struct BTA_FltFocusPreprocInst {
    BTA_ChannelId channelToProcess;
    BTA_ChannelId channelIdResult;
    BTA_InfoEventInst *infoEventInst;
    BTA_FltHandle cropHandle1;
    BTA_FltHandle cropHandle2;
    BTA_FltHandle cropHandle3;
    BTA_FltHandle cropHandle4;
    BTA_FltHandle cropChessboardHandle;
} BTA_FltFocusPreprocInst;


BTA_Status BFLTfocusPreprocInit(BTA_FltFocusPreprocConfig *config, BTA_FltHandle *handle, BTA_InfoEventInst *infoEventInst);
BTA_Status BFLTfocusPreprocClose(BTA_FltHandle *handle);
BTA_Status BFLTfocusPreprocApply(BTA_FltHandle handle, BTA_Frame **frame);


#endif
#endif